

 
 /****************************************************************
  **    Ex3.Test Graphic Mode                                   ** 
  **										                    **
  **   MCU        : AT89C51ED2                                  **
  **   Compiler   : Keil C51 (V8.05 a)                          **															   *
  **   Baudrate   : 115200 at Clock 18.432 Mhz(6 Clock Mode)	**
  **	                                                        **
  **   Port Control :                                           **
  **                 UART0: P3.0 = Rx0                          **
  **                        P3.1 = Tx0			                **
  **                                                            **
  **   Write By : Sittiphol Yooyod(ETT CO.,LTD.)                **
  **                                                            **
  ****************************************************************/ 
						
#include <at89c51xd2.h>
#include <stdio.h>


//----------- delay -------------

 void delay(int count)
  {
    int i,j ;
	for(i=0;i<count;i++)
	 for(j=0;j<count;j++);
  }


 //------ Check Respond Command -----

  void acho()
   { 
     unsigned char P,K;
     
	 do{
         P = _getkey();        //Read Respond 'O'  
       }while(P != 'O');
  
     do{
         K = _getkey();        //Read Respond 'K'
	   }while(K !='K') ;
   }

 //****************** Main Program *********************


 void main(void)
  {
   unsigned char n=0,m1,m2,esc=0x1B,enter=0x0D;
   int dly =150 ;
 
   CKCON0 = 0x01 ;  // div 6 clk mode  X2=1
   AUXR   = 0x10 ;  //Set XRAM = 1792 Byte
 
	
   //---------initial Uart0 ------------

        BRL     = 0xF6  ;  // Baud Rate 115200
        PCON   |= 0x80  ;  // Set SMOD1=1 :Double BR  
   
        BDRCON  = 0x1E  ;  // Select Internal Baud-Rate,enable,0x1E=Fast BR. //0x1C=No fast BR.	 
        SCON    = 0x50  ;  // Serial Mode1:8bit Uart,enable serial ,Clear Flag Rx/Tx 	   
        ES      = 0     ;  //Disable Serial Uart  Interrupt    
  
	    TI=1                            ;
        printf("%c00#00=%c",esc,enter)  ;   //Sent Cmm  Clear Screen
        while(TI == 0){;}                   //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;   //Check Respond CMM

 	    TI=1                            ;
        printf("%c00#10=063,32,30,0%c",esc,enter)  ;  //Sent Cmm Plot Circuit
        while(TI == 0){;}                             //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;             //Check Respond CMM

		TI=1                            ;
        printf("%c00#10=063,32,27,0%c",esc,enter)    ;   //Sent Cmm Plot Circuit
        while(TI == 0){;}                   //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;   //Check Respond CMM
 

	   	TI=1                            ;
        printf("%c00#30=050,13%c",esc,enter)    ;   //Sent Cmm Set Cursor Text
        while(TI == 0){;}                   //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;   //Check Respond CMM

 		TI=1                            ;
        printf("%c00#31=1:E   T%c",esc,enter)   ;   //Sent Cmm write Text
        while(TI == 0){;}                   //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;   //Check Respond CMM


		
	   	TI=1                            ;
        printf("%c00#30=052,32%c",esc,enter)    ;   //Sent Cmm Set Cursor Text
        while(TI == 0){;}                   //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;   //Check Respond CMM

 		TI=1                            ;
        printf("%c00#31=1:    T%c",esc,enter)    ;   //Sent Cmm write Text
        while(TI == 0){;}                   //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;   //Check Respond CMM

 
		
	   	TI=1                            ;
        printf("%c00#30=000,00%c",esc,enter)    ;   //Sent Cmm Set Cursor Text
        while(TI == 0){;}                   //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;   //Check Respond CMM

 		TI=1                            ;
        printf("%c00#31=1:00 ͺ%c",esc,enter)    ;   //Sent Cmm write Text
        while(TI == 0){;}                   //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;   //Check Respond CMM


 	while(1)
	 {   
	    // number 12
 	    TI=1                            ;
        printf("%c00#15=063,32,063,10%c",esc,enter)    ;   //Sent Cmm Plot Line
        while(TI == 0){;}                   //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;   //Check Respond CMM
 
 		delay(dly);
	    TI=1                            ;
        printf("%c00#14=063,32,063,10,2%c",esc,enter)    ;   //Sent Cmm Plot Rectang Del Line
        while(TI == 0){;}                   //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;   //Check Respond CMM
 


		//number 3
	    TI=1                            ;
        printf("%c00#15=063,32,085,32%c",esc,enter)    ;   //Sent Cmm Plot Line
        while(TI == 0){;}                   //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;   //Check Respond CMM
 
 		delay(dly);
	    TI=1                            ;
        printf("%c00#14=063,32,085,32,2%c",esc,enter)    ;   //Sent Cmm Plot Rectang Del Line
        while(TI == 0){;}                   //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;   //Check Respond CMM
	    



		//number 6
 	    TI=1                            ;
        printf("%c00#15=063,32,063,54%c",esc,enter)    ;   //Sent Cmm Plot Line
        while(TI == 0){;}                   //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;   //Check Respond CMM
 
 		delay(dly);
	    TI=1                            ;
        printf("%c00#14=063,32,063,54,2%c",esc,enter)    ;   //Sent Cmm Plot Rectang  Del Line
        while(TI == 0){;}                   //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;   //Check Respond CMM



	  //number 9
		TI=1                            ;
        printf("%c00#15=063,32,041,32%c",esc,enter)    ;   //Sent Cmm Plot Line
        while(TI == 0){;}                   //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;   //Check Respond CMM
 
 		delay(dly);
	    TI=1                            ;
        printf("%c00#14=063,32,041,32,2%c",esc,enter)    ;   //Sent Cmm Plot Rectang  Del Line
        while(TI == 0){;}                   //wait Sent CMM Finis Clear Flag TI
        TI=0                            ;    
	    acho()                          ;   //Check Respond CMM


		n = n+1 ;     // Incremend Round	  
		if(n>99)	  //Check Round
		 n=0    ;

  	   //---- Convert Round decimal to ASCII -----
        m1 =  (n/10)+0x30 ;
		m2 =  (n%10)+0x30 ;  

		TI=1                                 ;
        printf("%c00#30=000,00%c",esc,enter) ;   //Sent Cmm Set Cursor
        while(TI == 0){;}                        //wait Sent CMM Finis Clear Flag TI
        TI=0                                 ;    
	    acho()                               ;   //Check Respond CMM

	    TI=1                                 ;
        printf("%c00#14=000,05,015,12,2%c",esc,enter)  ;   //Sent Cmm Plot Rectang	Del Text
        while(TI == 0){;}                                  //wait Sent CMM Finis Clear Flag TI
        TI=0                                           ;    
	    acho()                                         ;   //Check Respond CMM


	    TI=1                                           ;
        printf("%c00#31=1:%c%c%c",esc,m1,m2,enter)     ;   //Sent Cmm write Text
        while(TI == 0){;}                                  //wait Sent CMM Finis Clear Flag TI
        TI=0                                           ;    
	    acho()                                         ;   //Check Respond CMM

    }

 }
